/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.registries;

import fr.iglee42.evolvedmekanism.registries.EMResources;
import fr.iglee42.evolvedmekanism.tiers.EMAlloyTier;
import fr.iglee42.evolvedmekanism.tiers.EMBaseTier;
import fr.iglee42.evolvedmekanism.tiers.storage.EMQIODriveTier;
import java.util.Locale;
import mekanism.api.text.TextComponentUtil;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.common.item.ItemAlloy;
import mekanism.common.item.ItemQIODrive;
import mekanism.common.item.ItemTierInstaller;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.resource.IResource;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tier.QIODriveTier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EMItems {
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("evolvedmekanism");
    public static final ItemRegistryObject<ItemTierInstaller> OVERCLOCKED_TIER_INSTALLER = EMItems.registerInstaller(BaseTier.ULTIMATE, EMBaseTier.OVERCLOCKED);
    public static final ItemRegistryObject<ItemTierInstaller> QUANTUM_TIER_INSTALLER = EMItems.registerInstaller(EMBaseTier.OVERCLOCKED, EMBaseTier.QUANTUM);
    public static final ItemRegistryObject<ItemTierInstaller> DENSE_TIER_INSTALLER = EMItems.registerInstaller(EMBaseTier.QUANTUM, EMBaseTier.DENSE);
    public static final ItemRegistryObject<ItemTierInstaller> MULTIVERSAL_TIER_INSTALLER = EMItems.registerInstaller(EMBaseTier.DENSE, EMBaseTier.MULTIVERSAL);
    public static final ItemRegistryObject<ItemTierInstaller> CREATIVE_TIER_INSTALLER = EMItems.registerInstaller(EMBaseTier.MULTIVERSAL, BaseTier.CREATIVE);
    public static final ItemRegistryObject<Item> OVERCLOCKED_CONTROL_CIRCUIT = EMItems.registerCircuit(EMBaseTier.OVERCLOCKED);
    public static final ItemRegistryObject<Item> QUANTUM_CONTROL_CIRCUIT = EMItems.registerCircuit(EMBaseTier.QUANTUM);
    public static final ItemRegistryObject<Item> DENSE_CONTROL_CIRCUIT = EMItems.registerCircuit(EMBaseTier.DENSE);
    public static final ItemRegistryObject<Item> MULTIVERSAL_CONTROL_CIRCUIT = EMItems.registerCircuit(EMBaseTier.MULTIVERSAL);
    public static final ItemRegistryObject<Item> CREATIVE_CONTROL_CIRCUIT = EMItems.registerCircuit(BaseTier.CREATIVE);
    public static final ItemRegistryObject<ItemQIODrive> BOOSTED_QIO_DRIVE = EMItems.registerQIODrive(EMQIODriveTier.BOOSTED);
    public static final ItemRegistryObject<ItemQIODrive> SINGULARITY_QIO_DRIVE = EMItems.registerQIODrive(EMQIODriveTier.SINGULARITY);
    public static final ItemRegistryObject<ItemQIODrive> HYPRA_SOLIDIFIED_QIO_DRIVE = EMItems.registerQIODrive(EMQIODriveTier.HYPRA_SOLIDIFIED);
    public static final ItemRegistryObject<ItemQIODrive> BLACK_HOLE_QIO_DRIVE = EMItems.registerQIODrive(EMQIODriveTier.BLACK_HOLE);
    public static final ItemRegistryObject<ItemQIODrive> CREATIVE_QIO_DRIVE = EMItems.registerQIODrive(EMQIODriveTier.CREATIVE);
    public static final ItemRegistryObject<ItemAlloy> HYPERCHARGED_ALLOY = EMItems.registerAlloy(EMAlloyTier.HYPERCHARGED);
    public static final ItemRegistryObject<ItemAlloy> SUBATOMIC_ALLOY = EMItems.registerAlloy(EMAlloyTier.SUBATOMIC);
    public static final ItemRegistryObject<ItemAlloy> SINGULAR_ALLOY = EMItems.registerAlloy(EMAlloyTier.SINGULAR);
    public static final ItemRegistryObject<ItemAlloy> EXOVERSAL_ALLOY = EMItems.registerAlloy(EMAlloyTier.EXOVERSAL);
    public static final ItemRegistryObject<ItemAlloy> CREATIVE_ALLOY = EMItems.registerAlloy(EMAlloyTier.CREATIVE);
    public static final ItemRegistryObject<Item> ENRICHED_URANIUM = EMItems.registerResource(ResourceType.ENRICHED, (IResource)PrimaryResource.URANIUM);
    public static final ItemRegistryObject<Item> ENRICHED_BETTER_GOLD = EMItems.registerResource(ResourceType.ENRICHED, EMResources.BETTER_GOLD);
    public static final ItemRegistryObject<Item> ENRICHED_PLASLITHERITE = EMItems.registerUnburnableResource(ResourceType.ENRICHED, EMResources.PLASLITHERITE);
    public static final ItemRegistryObject<Item> BETTER_GOLD_DUST = EMItems.registerResource(ResourceType.DUST, EMResources.BETTER_GOLD);
    public static final ItemRegistryObject<Item> PLASLITHERITE_DUST = EMItems.registerUnburnableResource(ResourceType.DUST, EMResources.PLASLITHERITE);
    public static final ItemRegistryObject<Item> BETTER_GOLD_INGOT = EMItems.registerResource(ResourceType.INGOT, EMResources.BETTER_GOLD);
    public static final ItemRegistryObject<Item> PLASLITHERITE_INGOT = EMItems.registerUnburnableResource(ResourceType.INGOT, EMResources.PLASLITHERITE);
    public static final ItemRegistryObject<Item> BETTER_GOLD_NUGGET = EMItems.registerResource(ResourceType.NUGGET, EMResources.BETTER_GOLD);
    public static final ItemRegistryObject<Item> PLASLITHERITE_NUGGET = EMItems.registerUnburnableResource(ResourceType.NUGGET, EMResources.PLASLITHERITE);

    private static ItemRegistryObject<Item> registerCircuit(final BaseTier tier) {
        return ITEMS.register(tier.getLowerName() + "_control_circuit", properties -> new Item((Item.Properties)properties){

            @NotNull
            public Component m_7626_(@NotNull ItemStack stack) {
                return TextComponentUtil.build((Object[])new Object[]{tier.getColor(), super.m_7626_(stack)});
            }
        });
    }

    private static ItemRegistryObject<ItemTierInstaller> registerInstaller(@Nullable BaseTier fromTier, @NotNull BaseTier toTier) {
        return ITEMS.register(toTier.getLowerName() + "_tier_installer", properties -> new ItemTierInstaller(fromTier, toTier, properties));
    }

    private static ItemRegistryObject<ItemAlloy> registerAlloy(final AlloyTier tier) {
        return ITEMS.register("alloy_" + tier.getName(), properties -> new ItemAlloy(tier, (Item.Properties)properties){

            @NotNull
            public Component m_7626_(@NotNull ItemStack stack) {
                return TextComponentUtil.build((Object[])new Object[]{tier.getBaseTier().getColor(), super.m_7626_(stack)});
            }
        });
    }

    private static ItemRegistryObject<Item> registerResource(ResourceType type, IResource resource) {
        return ITEMS.register(type.getRegistryPrefix() + "_" + resource.getRegistrySuffix());
    }

    private static ItemRegistryObject<Item> registerUnburnableResource(ResourceType type, IResource resource) {
        return ITEMS.registerUnburnable(type.getRegistryPrefix() + "_" + resource.getRegistrySuffix());
    }

    private static ItemRegistryObject<ItemQIODrive> registerQIODrive(QIODriveTier tier) {
        return ITEMS.register("qio_drive_" + tier.name().toLowerCase(Locale.ROOT), properties -> new ItemQIODrive(tier, properties));
    }
}

